; Compiled with: PIC Simulator IDE v9.70
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
;       The address of 'wheel_count1' (byte) (global) is 0x024
;       The address of 'wheel_count2' (byte) (global) is 0x025
;       The address of 'wheel_count3' (byte) (global) is 0x026
;       The address of 'wheel_count4' (byte) (global) is 0x027
;       The address of 'wheel_count5' (byte) (global) is 0x02A
;       The address of 'wheel_count6' (byte) (global) is 0x02B
;       The address of 'wheel_count7' (byte) (global) is 0x02C
;       The address of 'wheel_count8' (byte) (global) is 0x02D
;       The address of 'old_gate1' (bit) (global) is 0x02E,0
;       The address of 'old_gate2' (bit) (global) is 0x02E,1
;       The address of 'old_gate3' (bit) (global) is 0x02E,2
;       The address of 'old_gate4' (bit) (global) is 0x02E,3
;       The address of 'old_gate5' (bit) (global) is 0x02E,4
;       The address of 'old_gate6' (bit) (global) is 0x02E,5
;       The address of 'old_gate7' (bit) (global) is 0x02E,6
;       The address of 'old_gate8' (bit) (global) is 0x02E,7
;       The address of 'main_count' (word) (global) is 0x02F
;       The address of 'gate1' (bit) (global) is 0x005,1
;       The address of 'gate2' (bit) (global) is 0x005,2
;       The address of 'gate3' (bit) (global) is 0x005,0
;       The address of 'gate4' (bit) (global) is 0x005,3
;       The address of 'gate5' (bit) (global) is 0x005,7
;       The address of 'gate6' (bit) (global) is 0x005,4
;       The address of 'gate7' (bit) (global) is 0x005,6
;       The address of 'gate8' (bit) (global) is 0x005,5
;       The address of 'fb1' (bit) (global) is 0x006,4
;       The address of 'fb2' (bit) (global) is 0x006,5
;       The address of 'fb3' (bit) (global) is 0x006,6
;       The address of 'fb4' (bit) (global) is 0x006,7
;       The address of 'fb5' (bit) (global) is 0x006,3
;       The address of 'fb6' (bit) (global) is 0x006,2
;       The address of 'fb7' (bit) (global) is 0x006,1
;       The address of 'fb8' (bit) (global) is 0x006,0
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0005
	ORG 0x0004
	RETFIE
; User code start
L0005:
; 1: 
; 2: //firmware for GCA173 with PIC16F628(a) and octal GCA173_wheel_counter
; 3: //pulse extender for optogate with inverted outputs
; 4: //all outputs are normal high
; 5: //Output will be pulsed with the number of counted  wheels(x);  pulses are low active.
; 6: // counter contents generate the counted number pulses of 80 mSec with 80 mSec interval
; 7: //aug 17, 2023 initial start of this version
; 8: // 26 dec 2024 firmware corrected for low activce Pulse with GCA173_Wheel_counter pcb
; 9: Define CONF_WORD = 0x3f50
;       The value of 'CONF_WORD' is 16208
; 10: Define CLOCK_FREQUENCY = 4
;       The value of 'CLOCK_FREQUENCY' is 4
; 11: 
; 12: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 13: TRISA = 255
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
; 14: TRISB = 0
	CLRF TRISB
	BCF STATUS,RP0
; 15: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 16: AllDigital
	MOVLW 0x07
	MOVWF CMCON
	BSF STATUS,RP0
	BCF VRCON,6
	BCF STATUS,RP0
; 17: 
; 18: Symbol gate1 = RA1
; 19: Symbol gate2 = RA2
; 20: Symbol gate3 = RA0
; 21: Symbol gate4 = RA3
; 22: Symbol gate5 = RA7
; 23: Symbol gate6 = RA4
; 24: Symbol gate7 = RA6
; 25: Symbol gate8 = RA5
; 26: Symbol fb1 = RB4
; 27: Symbol fb2 = RB5
; 28: Symbol fb3 = RB6
; 29: Symbol fb4 = RB7
; 30: Symbol fb5 = RB3
; 31: Symbol fb6 = RB2
; 32: Symbol fb7 = RB1
; 33: Symbol fb8 = RB0
; 34: 
; 35: 
; 36: Dim wheel_count1 As Byte
; 37: Dim wheel_count2 As Byte
; 38: Dim wheel_count3 As Byte
; 39: Dim wheel_count4 As Byte
; 40: Dim wheel_count5 As Byte
; 41: Dim wheel_count6 As Byte
; 42: Dim wheel_count7 As Byte
; 43: Dim wheel_count8 As Byte
; 44: Dim old_gate1 As Bit
; 45: Dim old_gate2 As Bit
; 46: Dim old_gate3 As Bit
; 47: Dim old_gate4 As Bit
; 48: Dim old_gate5 As Bit
; 49: Dim old_gate6 As Bit
; 50: Dim old_gate7 As Bit
; 51: Dim old_gate8 As Bit
; 52: 
; 53: Dim main_count As Word
; 54: 
; 55: wheel_count1 = 0
	CLRF 0x024
; 56: wheel_count2 = 0
	CLRF 0x025
; 57: wheel_count3 = 0
	CLRF 0x026
; 58: wheel_count4 = 0
	CLRF 0x027
; 59: wheel_count5 = 0
	CLRF 0x02A
; 60: wheel_count6 = 0
	CLRF 0x02B
; 61: wheel_count7 = 0
	CLRF 0x02C
; 62: wheel_count8 = 0
	CLRF 0x02D
; 63: // Timer1 Registers:
; 64: // Prescaler=1:8; TMR1 Preset=21010; Freq=11,22939Hz; Period=89.052.000 ns
; 65: //T1CON.5 = 1  // bits 5-4  Prescaler Rate Select bits
; 66: //T1CON.4 = 1
; 67: //T1CON.3 = 1  // bit 3 Timer1 Oscillator Enable Control: bit 1=on
; 68: //T1CON.2 = 1  //bit 2 Timer1 External Clock Input Synchronization Control bit: 1=Do not synchronize external clock input
; 69: //T1CON.1 = 0  // bit 1 Timer1 Clock Source Select bit: 0=Internal clock (FOSC/4) / 1 = External clock from pin T1CKI (on the rising edge)
; 70: //T1CON.0 = 1  // bit 0 enables timer
; 71: //TMR1H = 0x52  // preset for timer1 MSB register
; 72: //TMR1L = 0x12  // preset for timer1 LSB register
; 73: 
; 74: Call init()  // show all leds at start
	CALL L0003
; 75: T1CON.TMR1ON = 1  // bit 0 enables timer
	BSF T1CON,0
; 76: main:
L0001:
; 77: 
; 78: 
; 79: 
; 80: //opto_gate 1
; 81: If gate1 = 0 Then  //reaction on low pulse
	BTFSC 0x005,1
	GOTO L0006
; 82: If old_gate1 = 1 Then
	BTFSS 0x02E,0
	GOTO L0007
; 83: old_gate1 = 0  //further reaction disabled
	BCF 0x02E,0
; 84: wheel_count1 = wheel_count1 + 1  // this count is done
	INCF 0x024,F
; 85: Endif
L0007:
; 86: Else
	GOTO L0008
L0006:
; 87: old_gate1 = 1  // enable new count
	BSF 0x02E,0
; 88: Endif
L0008:
; 89: 
; 90: 
; 91: //opto_gate 2
; 92: If gate2 = 0 Then  //reaction on low pulse
	BTFSC 0x005,2
	GOTO L0009
; 93: If old_gate2 = 1 Then
	BTFSS 0x02E,1
	GOTO L0010
; 94: old_gate2 = 0  //further reaction disabled
	BCF 0x02E,1
; 95: wheel_count2 = wheel_count2 + 1  // this count is done
	INCF 0x025,F
; 96: Endif
L0010:
; 97: Else
	GOTO L0011
L0009:
; 98: old_gate2 = 1  // enable new count
	BSF 0x02E,1
; 99: Endif
L0011:
; 100: 
; 101: 'opto_gate 3
; 102: If gate3 = 0 Then  //reaction on low pulse
	BTFSC 0x005,0
	GOTO L0012
; 103: If old_gate3 = 1 Then
	BTFSS 0x02E,2
	GOTO L0013
; 104: old_gate3 = 0  //further reaction disabled
	BCF 0x02E,2
; 105: wheel_count3 = wheel_count3 + 1  // this count is done
	INCF 0x026,F
; 106: Endif
L0013:
; 107: Else
	GOTO L0014
L0012:
; 108: old_gate3 = 1  // enable new count
	BSF 0x02E,2
; 109: Endif
L0014:
; 110: 
; 111: 'opto_gate 4
; 112: If gate4 = 0 Then  //reaction on low pulse
	BTFSC 0x005,3
	GOTO L0015
; 113: If old_gate4 = 1 Then
	BTFSS 0x02E,3
	GOTO L0016
; 114: old_gate4 = 0  //further reaction disabled
	BCF 0x02E,3
; 115: wheel_count4 = wheel_count4 + 1  // this count is done
	INCF 0x027,F
; 116: Endif
L0016:
; 117: Else
	GOTO L0017
L0015:
; 118: old_gate4 = 1  // enable new count
	BSF 0x02E,3
; 119: Endif
L0017:
; 120: 
; 121: 'opto_gate 5
; 122: If gate5 = 0 Then  //reaction on low pulse
	BTFSC 0x005,7
	GOTO L0018
; 123: If old_gate5 = 1 Then
	BTFSS 0x02E,4
	GOTO L0019
; 124: old_gate5 = 0  //further reaction disabled
	BCF 0x02E,4
; 125: wheel_count5 = wheel_count5 + 1  // this count is done
	INCF 0x02A,F
; 126: Endif
L0019:
; 127: Else
	GOTO L0020
L0018:
; 128: old_gate5 = 1  // enable new count
	BSF 0x02E,4
; 129: Endif
L0020:
; 130: 
; 131: 'opto_gate 6
; 132: If gate6 = 0 Then  //reaction on low pulse
	BTFSC 0x005,4
	GOTO L0021
; 133: If old_gate6 = 1 Then
	BTFSS 0x02E,5
	GOTO L0022
; 134: old_gate6 = 0  //further reaction disabled
	BCF 0x02E,5
; 135: wheel_count6 = wheel_count6 + 1  // this count is done
	INCF 0x02B,F
; 136: Endif
L0022:
; 137: Else
	GOTO L0023
L0021:
; 138: old_gate6 = 1  // enable new count
	BSF 0x02E,5
; 139: Endif
L0023:
; 140: 
; 141: 'opto_gate 7
; 142: If gate7 = 0 Then  //reaction on low pulse
	BTFSC 0x005,6
	GOTO L0024
; 143: If old_gate7 = 1 Then
	BTFSS 0x02E,6
	GOTO L0025
; 144: old_gate7 = 0  //further reaction disabled
	BCF 0x02E,6
; 145: wheel_count7 = wheel_count7 + 1  // this count is done
	INCF 0x02C,F
; 146: Endif
L0025:
; 147: Else
	GOTO L0026
L0024:
; 148: old_gate7 = 1  // enable new count
	BSF 0x02E,6
; 149: Endif
L0026:
; 150: 
; 151: 'opto_gate 8
; 152: If gate8 = 0 Then  //reaction on low pulse
	BTFSC 0x005,5
	GOTO L0027
; 153: If old_gate8 = 1 Then
	BTFSS 0x02E,7
	GOTO L0028
; 154: old_gate8 = 0  //further reaction disabled
	BCF 0x02E,7
; 155: wheel_count8 = wheel_count8 + 1  // this count is done
	INCF 0x02D,F
; 156: Endif
L0028:
; 157: Else
	GOTO L0029
L0027:
; 158: old_gate8 = 1  // enable new count
	BSF 0x02E,7
; 159: Endif
L0029:
; 160: 
; 161: main_count = main_count + 1
	INCF 0x02F,F
	BTFSC STATUS,Z
	INCF 0x030,F
; 162: Call outputcontrol()
	CALL L0002
; 163: 
; 164: Goto main
	GOTO L0001
; 165: 
; 166: End
L0030:	GOTO L0030
; 167: //On Interrupt
; 168: 
; 169: //	TMR1H = 0x52  ' preset for timer1 MSB register
; 170: //	TMR1L = 0x12  // preset for timer1 LSB register
; 171: //	Call outputcontrol()
; 172: //	T1CON.TMR1ON = 1  // bit 0 enables timer
; 173: //Resume
; 174: Proc outputcontrol()
L0002:
; 175: If main_count = 800 Then
	MOVF 0x02F,W
	MOVWF R0L
	MOVF 0x030,W
	MOVWF R0H
	MOVLW 0x20
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	CALL C001
	BTFSS STATUS,Z
	GOTO L0031
; 176: // fb1
; 177: If fb1 = 0 Then
	BTFSC 0x006,4
	GOTO L0032
; 178: fb1 = 1  //pulse end
	BSF PORTB,4
; 179: Else
	GOTO L0033
L0032:
; 180: If wheel_count1 > 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0034
; 181: wheel_count1 = wheel_count1 - 1
	DECF 0x024,F
; 182: fb1 = 0  // start newpulse
	BCF PORTB,4
; 183: Endif
L0034:
; 184: Endif
L0033:
; 185: 
; 186: // fb2
; 187: If fb2 = 0 Then
	BTFSC 0x006,5
	GOTO L0035
; 188: fb2 = 1   //pulse end
	BSF PORTB,5
; 189: Else
	GOTO L0036
L0035:
; 190: If wheel_count2 > 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0037
; 191: wheel_count2 = wheel_count2 - 1
	DECF 0x025,F
; 192: fb2 = 0  // start new pulse
	BCF PORTB,5
; 193: Endif
L0037:
; 194: Endif
L0036:
; 195: 
; 196: // fb3
; 197: If fb3 = 0 Then
	BTFSC 0x006,6
	GOTO L0038
; 198: fb3 = 1   //pulse end
	BSF PORTB,6
; 199: Else
	GOTO L0039
L0038:
; 200: If wheel_count3 > 0 Then
	MOVF 0x026,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0040
; 201: wheel_count3 = wheel_count3 - 1
	DECF 0x026,F
; 202: fb3 = 0  // start new pulse
	BCF PORTB,6
; 203: Endif
L0040:
; 204: Endif
L0039:
; 205: 
; 206: // fb4
; 207: If fb4 = 0 Then
	BTFSC 0x006,7
	GOTO L0041
; 208: fb4 = 1   //pulse end
	BSF PORTB,7
; 209: Else
	GOTO L0042
L0041:
; 210: If wheel_count4 > 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0043
; 211: wheel_count4 = wheel_count4 - 1
	DECF 0x027,F
; 212: fb4 = 0  // start new pulse
	BCF PORTB,7
; 213: Endif
L0043:
; 214: Endif
L0042:
; 215: // fb5
; 216: If fb5 = 0 Then
	BTFSC 0x006,3
	GOTO L0044
; 217: fb5 = 1   //pulse end
	BSF PORTB,3
; 218: Else
	GOTO L0045
L0044:
; 219: If wheel_count5 > 0 Then
	MOVF 0x02A,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0046
; 220: wheel_count5 = wheel_count5 - 1
	DECF 0x02A,F
; 221: fb5 = 0  // start new pulse
	BCF PORTB,3
; 222: Endif
L0046:
; 223: Endif
L0045:
; 224: // fb6
; 225: If fb6 = 0 Then
	BTFSC 0x006,2
	GOTO L0047
; 226: fb6 = 1   //pulse end
	BSF PORTB,2
; 227: Else
	GOTO L0048
L0047:
; 228: If wheel_count6 > 0 Then
	MOVF 0x02B,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0049
; 229: wheel_count6 = wheel_count6 - 1
	DECF 0x02B,F
; 230: fb6 = 0  // start new pulse
	BCF PORTB,2
; 231: Endif
L0049:
; 232: Endif
L0048:
; 233: // fb6
; 234: If fb7 = 0 Then
	BTFSC 0x006,1
	GOTO L0050
; 235: fb7 = 1   //pulse end
	BSF PORTB,1
; 236: Else
	GOTO L0051
L0050:
; 237: If wheel_count7 > 0 Then
	MOVF 0x02C,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0052
; 238: wheel_count7 = wheel_count7 - 1
	DECF 0x02C,F
; 239: fb7 = 0  // start new pulse
	BCF PORTB,1
; 240: Endif
L0052:
; 241: Endif
L0051:
; 242: // fb8
; 243: If fb8 = 0 Then
	BTFSC 0x006,0
	GOTO L0053
; 244: fb8 = 1   //pulse end
	BSF PORTB,0
; 245: Else
	GOTO L0054
L0053:
; 246: If wheel_count8 > 0 Then
	MOVF 0x02D,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0055
; 247: wheel_count8 = wheel_count8 - 1
	DECF 0x02D,F
; 248: fb8 = 0  // start new pulse
	BCF PORTB,0
; 249: Endif
L0055:
; 250: Endif
L0054:
; 251: Else
	GOTO L0056
L0031:
; 252: If main_count > 1600 Then
	MOVLW 0x40
	MOVWF R0L
	MOVLW 0x06
	MOVWF R0H
	MOVF 0x02F,W
	MOVWF R1L
	MOVF 0x030,W
	MOVWF R1H
	CALL C001
	BTFSC STATUS,C
	GOTO L0057
; 253: main_count = 0
	CLRF 0x02F
	CLRF 0x030
; 254: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 255: Endif
L0057:
; 256: Endif
L0056:
; 257: 
; 258: 
; 259: End Proc
	RETURN
; 260: Proc init()
L0003:
; 261: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 262: fb1 = 0
	BCF PORTB,4
; 263: WaitMs 250
	MOVLW 0xA6
	MOVWF R4L
	MOVLW 0x61
	MOVWF R4H
	CALL DL02
; 264: fb1 = 1
	BSF PORTB,4
; 265: fb2 = 0
	BCF PORTB,5
; 266: WaitMs 250
	MOVLW 0xA6
	MOVWF R4L
	MOVLW 0x61
	MOVWF R4H
	CALL DL02
; 267: fb2 = 1
	BSF PORTB,5
; 268: fb3 = 0
	BCF PORTB,6
; 269: WaitMs 250
	MOVLW 0xA6
	MOVWF R4L
	MOVLW 0x61
	MOVWF R4H
	CALL DL02
; 270: fb3 = 1
	BSF PORTB,6
; 271: fb4 = 0
	BCF PORTB,7
; 272: WaitMs 250
	MOVLW 0xA6
	MOVWF R4L
	MOVLW 0x61
	MOVWF R4H
	CALL DL02
; 273: fb4 = 1
	BSF PORTB,7
; 274: fb5 = 0
	BCF PORTB,3
; 275: WaitMs 250
	MOVLW 0xA6
	MOVWF R4L
	MOVLW 0x61
	MOVWF R4H
	CALL DL02
; 276: fb5 = 1
	BSF PORTB,3
; 277: fb6 = 0
	BCF PORTB,2
; 278: WaitMs 250
	MOVLW 0xA6
	MOVWF R4L
	MOVLW 0x61
	MOVWF R4H
	CALL DL02
; 279: fb6 = 1
	BSF PORTB,2
; 280: fb7 = 0
	BCF PORTB,1
; 281: WaitMs 250
	MOVLW 0xA6
	MOVWF R4L
	MOVLW 0x61
	MOVWF R4H
	CALL DL02
; 282: fb7 = 1
	BSF PORTB,1
; 283: fb8 = 0
	BCF PORTB,0
; 284: WaitMs 250
	MOVLW 0xA6
	MOVWF R4L
	MOVLW 0x61
	MOVWF R4H
	CALL DL02
; 285: fb8 = 1
	BSF PORTB,0
; 286: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 287: End Proc
	RETURN
; Library code
L0004:
	RETURN
; End of user code
L0058:	GOTO L0058
;
;
; Delay Routine Byte
; minimal routine execution time: 8us
; routine execution time step: 3us
; maximal routine execution time: 770us
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15us
; routine execution time step: 10us
; maximal routine execution time: 655365us
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
; Word Comparison Routine
C001:
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C002
	MOVF R1L,W
	SUBWF R0L,W
C002:	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
